# UI/UX Keywords Reference

Progressive disclosure reference for common UI terminology and adjective palettes.

## Component Keywords

### Navigation
- navigation bar, nav menu, header
- breadcrumbs, tabs, sidebar
- hamburger menu, dropdown menu
- back button, close button

### Content Containers
- hero section, hero banner
- card, card grid, tile
- modal, dialog, popup
- accordion, collapsible section
- carousel, slider

### Forms
- input field, text input
- dropdown, select menu
- checkbox, radio button
- toggle switch
- date picker, time picker
- search bar, search input
- submit button, form actions

### Calls to Action
- primary button, secondary button
- ghost button, text link
- floating action button (FAB)
- icon button

### Feedback
- toast notification, snackbar
- alert banner, warning message
- loading spinner, skeleton loader
- progress bar, step indicator

### Layout
- grid layout, flexbox
- sidebar layout, split view
- sticky header, fixed footer
- full-width, contained width
- centered content, max-width container

## Adjective Palettes

### Minimal / Clean
- minimal, clean, uncluttered
- generous whitespace, breathing room
- subtle, understated, refined
- simple, focused, distraction-free

### Professional / Corporate
- sophisticated, polished, trustworthy
- corporate, business-like, formal
- subtle shadows, clean lines
- structured, organized, hierarchical

### Playful / Fun
- vibrant, colorful, energetic
- rounded corners, soft edges
- bold, expressive, dynamic
- friendly, approachable, warm

### Premium / Luxury
- elegant, luxurious, high-end
- dramatic, bold contrasts
- sleek, modern, cutting-edge
- exclusive, boutique, curated

### Dark Mode
- dark theme, night mode
- high-contrast accents
- soft glows, subtle highlights
- deep backgrounds, muted surfaces

### Organic / Natural
- earthy tones, natural colors
- warm, inviting, cozy
- textured, tactile, handcrafted
- flowing, organic shapes

## Color Role Terminology

### Backgrounds
- page background, canvas
- surface color, card background
- overlay, scrim

### Text
- primary text, heading color
- secondary text, body copy
- muted text, placeholder
- inverse text (on dark backgrounds)

### Accents
- primary accent, brand color
- secondary accent, highlight
- success, error, warning colors
- hover state, active state

## Shape Descriptions

| Technical | Natural Language |
|-----------|------------------|
| `rounded-none` | sharp, squared-off edges |
| `rounded-sm` | slightly softened corners |
| `rounded-md` | gently rounded corners |
| `rounded-lg` | generously rounded corners |
| `rounded-xl` | very rounded, pillow-like |
| `rounded-full` | pill-shaped, circular |
