---
name: wiki-onboarding
description: Generates two complementary onboarding guides — a Principal-Level architectural deep-dive and a Zero-to-Hero contributor walkthrough. Use when the user wants onboarding documentation for a codebase.
---

# Wiki Onboarding Guide Generator

Generate two complementary onboarding documents that together give any engineer — from newcomer to principal — a complete understanding of a codebase.

## When to Activate

- User asks for onboarding docs or getting-started guides
- User runs `/deep-wiki:onboard` command
- User wants to help new team members understand a codebase

## Language Detection

Scan the repository for build files to determine the primary language for code examples:
- `package.json` / `tsconfig.json` → TypeScript/JavaScript
- `*.csproj` / `*.sln` → C# / .NET
- `Cargo.toml` → Rust
- `pyproject.toml` / `setup.py` / `requirements.txt` → Python
- `go.mod` → Go
- `pom.xml` / `build.gradle` → Java

## Guide 1: Principal-Level Onboarding

**Audience**: Senior/staff+ engineers who need the "why" behind decisions.

### Required Sections

1. **System Philosophy & Design Principles** — What invariants does the system maintain? What were the key design choices and why?
2. **Architecture Overview** — Component map with Mermaid diagram. What owns what, communication patterns.
3. **Key Abstractions & Interfaces** — The load-bearing abstractions everything depends on
4. **Decision Log** — Major architectural decisions with context, alternatives considered, trade-offs
5. **Dependency Rationale** — Why each major dependency was chosen, what it replaced
6. **Data Flow & State** — How data moves through the system (traced from actual code, not guessed)
7. **Failure Modes & Error Handling** — What breaks, how errors propagate, recovery patterns
8. **Performance Characteristics** — Bottlenecks, scaling limits, hot paths
9. **Security Model** — Auth, authorization, trust boundaries, data sensitivity
10. **Testing Strategy** — What's tested, what isn't, testing philosophy
11. **Operational Concerns** — Deployment, monitoring, feature flags, configuration
12. **Known Technical Debt** — Honest assessment of shortcuts and their risks

### Rules
- Every claim backed by `(file_path:line_number)` citation
- Minimum 3 Mermaid diagrams (architecture, data flow, dependency graph)
- All Mermaid diagrams use dark-mode colors (see wiki-vitepress skill)
- Focus on WHY decisions were made, not just WHAT exists

## Guide 2: Zero-to-Hero Contributor Guide

**Audience**: New contributors who need step-by-step practical guidance.

### Required Sections

1. **What This Project Does** — 2-3 sentence elevator pitch
2. **Prerequisites** — Tools, versions, accounts needed
3. **Environment Setup** — Step-by-step with exact commands, expected output at each step
4. **Project Structure** — Annotated directory tree (what lives where and why)
5. **Your First Task** — End-to-end walkthrough of adding a simple feature
6. **Development Workflow** — Branch strategy, commit conventions, PR process
7. **Running Tests** — How to run tests, what to test, how to add a test
8. **Debugging Guide** — Common issues and how to diagnose them
9. **Key Concepts** — Domain-specific terminology explained with code examples
10. **Code Patterns** — "If you want to add X, follow this pattern" templates
11. **Common Pitfalls** — Mistakes every new contributor makes and how to avoid them
12. **Where to Get Help** — Communication channels, documentation, key contacts
13. **Glossary** — Terms used in the codebase that aren't obvious
14. **Quick Reference Card** — Cheat sheet of most-used commands and patterns

### Rules
- All code examples in the detected primary language
- Every command must be copy-pasteable
- Include expected output for verification steps
- Use Mermaid for workflow diagrams (dark-mode colors)
- Ground all claims in actual code — cite `(file_path:line_number)`
